#ifndef UART_SYSTEM_H
#define UART_SYSTEM_H

#include "DataType.h"

// <<< Use Configuration Wizard in Context Menu >>>

	// <e> UART Enable/Disable
		#define dUART_MODE 	0
			#if (dUART_MODE == 1)	
				// <o> Baudrate <0x02C7=> 9600 <0x03E5=> 115200
				// <i> Formula : (1024 - ( (24Mhz/8) / UART_Baudrate)
					#define UART_Baudrate 	0x03E5
			#endif
	// </e>
	
// <<< end of configuration section >>>

enum TXStatus{TX_SEND, TX_FINISH};
enum RXStatus{RX_INT, RX_HANDLE, RX_FINISH};

typedef xdata uint8 xuint8_t;
typedef xdata uint16 xuint16_t;
typedef xdata int16 xint16_t;

extern uint16 UartCount;
extern uint8 UartFlag;

extern xint16_t Debug_A;
extern xint16_t Debug_B;
extern xint16_t Debug_C;
extern xint16_t Debug_D;
extern xint16_t Debug_E;
extern xint16_t Debug_F;

extern xuint8_t TxFinish;
extern xuint8_t RxState;
extern xuint8_t Debug_TxCounter;
extern xuint8_t Debug_RxCounter;
extern xuint8_t Debug_PreRxCounter;
extern xuint8_t Debug_TxBuffer[20];
extern xuint8_t Debug_RxBuffer[20];
extern xuint8_t Debug_TxDataLen;

//extern uint16 CheckSUM;

extern void Uart_Definition(void);
extern void Uart_Package_Build(void);
extern void Uart_ReadPackage_Build(void);
extern void Uart_Read_Handle(void);
extern void Uart_Send_Buffer(void);
extern void Uart_Read_Buffer(void);
extern void Uart_CheckSum_Fun(void);
extern void UART_Send_char(unsigned char ucData);
extern void UART_Send_int(unsigned int uiData);
#endif